@extends('admin.layouts.app')

@section('title', 'Package Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Package Details</h5>
                    <div>
                        <a href="{{ route('admin.packages.edit', $package) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Edit Package
                        </a>
                        <a href="{{ route('admin.packages.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th width="200">Name</th>
                                    <td>
                                        <span class="badge" style="background-color: {{ $package->color }}">
                                            {{ $package->name }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Description</th>
                                    <td>{{ $package->description ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <th>Price</th>
                                    <td>{{ number_format($package->package_price, 2) }}</td>
                                </tr>
                                <tr>
                                    <th>Duration</th>
                                    <td>{{ ucfirst($package->duration) }}</td>
                                </tr>
                                <tr>
                                    <th>Status</th>
                                    <td>
                                        <span class="badge bg-{{ $package->status === 'active' ? 'success' : 'danger' }}">
                                            {{ ucfirst($package->status) }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Withdraw Limit</th>
                                    <td>{{ number_format($package->withdraw_limit, 2) }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th width="200">Space Limit</th>
                                    <td>{{ $package->space_limit }}</td>
                                </tr>
                                <tr>
                                    <th>Product Limit</th>
                                    <td>{{ $package->product_limit }}</td>
                                </tr>
                                <tr>
                                    <th>Job Limit</th>
                                    <td>{{ $package->job_limit }}</td>
                                </tr>
                                <tr>
                                    <th>Course Limit</th>
                                    <td>{{ $package->course_limit }}</td>
                                </tr>
                                <tr>
                                    <th>Event Limit</th>
                                    <td>{{ $package->event_limit }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <h6>Features</h6>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Feature</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Verified Badge</td>
                                            <td>
                                                @if($package->verified_badge)
                                                    <span class="badge bg-success">Yes</span>
                                                @else
                                                    <span class="badge bg-danger">No</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Edit Post</td>
                                            <td>
                                                @if($package->edit_post)
                                                    <span class="badge bg-success">Yes</span>
                                                @else
                                                    <span class="badge bg-danger">No</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Business Page</td>
                                            <td>
                                                @if($package->business_page)
                                                    <span class="badge bg-success">Yes</span>
                                                @else
                                                    <span class="badge bg-danger">No</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <h6>Timestamps</h6>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <tr>
                                        <th width="200">Created At</th>
                                        <td>{{ $package->created_at->format('d M Y H:i:s') }}</td>
                                    </tr>
                                    <tr>
                                        <th>Updated At</th>
                                        <td>{{ $package->updated_at->format('d M Y H:i:s') }}</td>
                                    </tr>
                                    @if($package->deleted_at)
                                    <tr>
                                        <th>Deleted At</th>
                                        <td>{{ $package->deleted_at->format('d M Y H:i:s') }}</td>
                                    </tr>
                                    @endif
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
