@extends('admin.layouts.home')

@section('title', 'Create Package')

@push('styles')
<link rel="stylesheet" href="{{ asset('assets/vendor/spectrum/spectrum.min.css') }}">
@endpush

@section('content')
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-box fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Create Package</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item">
                                                    <i class="bi bi-speedometer2 me-1"></i>
                                                    <a href="{{ url('/admin') }}" class="text-white-50">Dashboard</a>
                                                </li>
                                                <li class="breadcrumb-item">
                                                    <a href="{{ route('admin.packages.index') }}" class="text-white-50">Packages</a>
                                                </li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Create Package</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Create Package Form -->
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.packages.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="package_price" class="form-label">Price <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" class="form-control @error('package_price') is-invalid @enderror" id="package_price" name="package_price" value="{{ old('package_price') }}" required>
                                @error('package_price')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                      
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="duration" class="form-label">Duration <span class="text-danger">*</span></label>
                                <select class="form-select @error('duration') is-invalid @enderror" id="duration" name="duration" required>
                                    <option value="">Select Duration</option>
                                    <option value="day" {{ old('duration') == 'day' ? 'selected' : '' }}>Day</option>
                                    <option value="week" {{ old('duration') == 'week' ? 'selected' : '' }}>Week</option>
                                    <option value="month" {{ old('duration') == 'month' ? 'selected' : '' }}>Month</option>
                                    <option value="year" {{ old('duration') == 'year' ? 'selected' : '' }}>Year</option>
                                    <option value="unlimited" {{ old('duration') == 'unlimited' ? 'selected' : '' }}>Unlimited</option>
                                </select>
                                @error('duration')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                <select class="form-select @error('status') is-invalid @enderror" id="status" name="status" required>
                                    <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="disable" {{ old('status') == 'disable' ? 'selected' : '' }}>Disable</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                  
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="withdraw_limit" class="form-label">Withdraw Limit <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" class="form-control @error('withdraw_limit') is-invalid @enderror" id="withdraw_limit" name="withdraw_limit" value="{{ old('withdraw_limit', 0) }}" required>
                                @error('withdraw_limit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="event_limit" class="form-label">Event Limit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('event_limit') is-invalid @enderror" id="event_limit" name="event_limit" value="{{ old('event_limit', 0) }}" required>
                                @error('event_limit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="space_limit" class="form-label">Space Limit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('space_limit') is-invalid @enderror" id="space_limit" name="space_limit" value="{{ old('space_limit', 0) }}" required>
                                @error('space_limit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="product_limit" class="form-label">Product Limit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('product_limit') is-invalid @enderror" id="product_limit" name="product_limit" value="{{ old('product_limit', 0) }}" required>
                                @error('product_limit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="job_limit" class="form-label">Job Limit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('job_limit') is-invalid @enderror" id="job_limit" name="job_limit" value="{{ old('job_limit', 0) }}" required>
                                @error('job_limit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="course_limit" class="form-label">Course Limit <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('course_limit') is-invalid @enderror" id="course_limit" name="course_limit" value="{{ old('course_limit', 0) }}" required>
                                @error('course_limit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input type="checkbox" class="form-check-input @error('verified_badge') is-invalid @enderror" 
                                           id="verified_badge" name="verified_badge" value="1" 
                                           {{ old('verified_badge') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="verified_badge">Verified Badge</label>
                                    @error('verified_badge')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    
                        <div class="col-md-12">
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input type="checkbox" class="form-check-input @error('edit_post') is-invalid @enderror" 
                                           id="edit_post" name="edit_post" value="1" 
                                           {{ old('edit_post') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="edit_post">Allow Edit Post</label>
                                    @error('edit_post')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    
                        <div class="col-md-12">
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input type="checkbox" class="form-check-input @error('business_page') is-invalid @enderror" 
                                           id="business_page" name="business_page" value="1" 
                                           {{ old('business_page') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="business_page">Business Page</label>
                                    @error('business_page')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    

                    <div class="row ">
                        <div class="col-md-12">
                            <div class="d-flex justify-content-start">
                                <button type="submit" class="btn btn-primary me-3">Create Package</button>
                                <a href="{{ route('admin.packages.index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')

<script src="{{ asset('assets/vendor/spectrum/spectrum.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>

<script>
$(document).ready(function() {
    // Color Picker
    $('.color-picker').spectrum({
        type: "component",
        preferredFormat: "hex",
        showInput: true
    });

    // jQuery Validation
    $("#packageForm").validate({
        rules: {
            name: {
                required: true,
                minlength: 3
            },
            package_price: {
                required: true,
                number: true,
                min: 0.01
            },
            duration: {
                required: true
            },
            status: {
                required: true
            },
            withdraw_limit: {
                required: true,
                number: true,
                min: 0
            },
            space_limit: {
                required: true,
                number: true,
                min: 0
            },
            product_limit: {
                required: true,
                number: true,
                min: 0
            },
            job_limit: {
                required: true,
                number: true,
                min: 0
            },
            course_limit: {
                required: true,
                number: true,
                min: 0
            },
            event_limit: {
                required: true,
                number: true,
                min: 0
            }
        },
        messages: {
            name: {
                required: "Please enter package name",
                minlength: "Name must be at least 3 characters"
            },
            package_price: {
                required: "Please enter package price",
                number: "Please enter a valid number",
                min: "Price must be greater than 0"
            },
            duration: {
                required: "Please select a duration"
            },
            status: {
                required: "Please select a status"
            },
            withdraw_limit: {
                required: "Please enter withdraw limit",
                number: "Enter a valid number"
            },
            space_limit: {
                required: "Please enter space limit",
                number: "Enter a valid number"
            },
            product_limit: {
                required: "Please enter product limit",
                number: "Enter a valid number"
            },
            job_limit: {
                required: "Please enter job limit",
                number: "Enter a valid number"
            },
            course_limit: {
                required: "Please enter course limit",
                number: "Enter a valid number"
            },
            event_limit: {
                required: "Please enter event limit",
                number: "Enter a valid number"
            }
        },
        errorClass: "is-invalid",
        validClass: "is-valid",
        errorElement: "div",
        errorPlacement: function(error, element) {
            error.addClass("invalid-feedback");
            if (element.parent(".input-group").length) {
                error.insertAfter(element.parent()); // For input groups
            } else {
                error.insertAfter(element); // Default
            }
        }
    });
});
</script>


@endpush
