@extends('admin.layouts.home')

@section('title', 'Product Details')

@section('styles')
<style>
    .product-image-container {
        position: relative;
        overflow: hidden;
        border-radius: 10px;
        height: 400px;
    }
    
    .product-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .product-thumbnail {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }
    
    .product-thumbnail:hover, .product-thumbnail.active {
        transform: translateY(-5px);
        border-color: #0d6efd;
    }
    
    .status-badge {
        padding: 5px 10px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 500;
    }
    
    .detail-card {
        border-radius: 10px;
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .detail-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
    
    .related-product-card {
        border-radius: 10px;
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .related-product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
    
    .related-product-image {
        height: 150px;
        object-fit: cover;
    }
    
    .nav-tabs .nav-link {
        border: none;
        border-bottom: 3px solid transparent;
        color: #6c757d;
    }
    
    .nav-tabs .nav-link.active {
        border-bottom: 3px solid #0d6efd;
        color: #0d6efd;
        background: transparent;
    }
    
    .review-avatar {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        object-fit: cover;
    }
    
    .star-rating {
        color: #ffc107;
    }
</style>
@endsection

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="mt-4">Product Details</h1>
        <div>
            <a href="{{ route('admin.marketplace.products') }}" class="btn btn-outline-primary">
                <i class="fas fa-arrow-left me-1"></i> Back to Products
            </a>
        </div>
    </div>
    
    <div class="row">
        <!-- Product Images -->
        <div class="col-lg-5 mb-4">
            <div class="card detail-card">
                <div class="card-body">
                    <div class="product-image-container mb-3">
                        @if($product->images && count(json_decode($product->images)) > 0)
                            <img id="mainProductImage" src="{{ asset('storage/' . json_decode($product->images)[0]) }}" alt="{{ $product->name }}" class="product-image">
                        @elseif($product->thumbnail)
                            <img id="mainProductImage" src="{{ asset('storage/' . $product->thumbnail) }}" alt="{{ $product->name }}" class="product-image">
                        @else
                            <div class="d-flex align-items-center justify-content-center h-100 bg-light">
                                <i class="fas fa-image fa-5x text-secondary"></i>
                            </div>
                        @endif
                    </div>
                    
                    @if($product->images && count(json_decode($product->images)) > 1)
                        <div class="d-flex flex-wrap gap-2 justify-content-center">
                            @foreach(json_decode($product->images) as $index => $image)
                                <img src="{{ asset('storage/' . $image) }}" 
                                     alt="{{ $product->name }} image {{ $index + 1 }}" 
                                     class="product-thumbnail {{ $index === 0 ? 'active' : '' }}"
                                     onclick="changeMainImage('{{ asset('storage/' . $image) }}', this)">
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Product Info -->
        <div class="col-lg-7 mb-4">
            <div class="card detail-card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Product Information</h5>
                    <div>
                        <button type="button" class="btn btn-warning btn-sm me-2" data-bs-toggle="modal" data-bs-target="#statusModal">
                            <i class="fas fa-sync-alt me-1"></i> Update Status
                        </button>
                        <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteModal">
                            <i class="fas fa-trash me-1"></i> Delete
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="mb-4">
                        <h3>{{ $product->name }}</h3>
                        <div class="d-flex align-items-center mb-2">
                            @php
                                $statusClass = [
                                    'active' => 'bg-success',
                                    'inactive' => 'bg-danger',
                                    'pending' => 'bg-warning text-dark',
                                ][$product->status] ?? 'bg-secondary';
                            @endphp
                            <span class="status-badge {{ $statusClass }} me-2">
                                {{ ucfirst($product->status) }}
                            </span>
                            
                            <span class="text-muted">SKU: {{ $product->sku ?? 'N/A' }}</span>
                        </div>
                        <h4 class="text-primary">${{ number_format($product->price, 2) }}</h4>
                    </div>
                    
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <h6 class="text-muted">Category</h6>
                                <p>{{ $product->category->name ?? 'Uncategorized' }}</p>
                            </div>
                            
                            <div class="mb-3">
                                <h6 class="text-muted">Store</h6>
                                <p>
                                    @if($product->store)
                                        <a href="{{ route('admin.marketplace.stores.show', $product->store->id) }}">
                                            {{ $product->store->name }}
                                        </a>
                                    @else
                                        N/A
                                    @endif
                                </p>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <h6 class="text-muted">Stock</h6>
                                <p>
                                    @if($product->stock > 10)
                                        <span class="badge bg-success">{{ $product->stock }} in stock</span>
                                    @elseif($product->stock > 0)
                                        <span class="badge bg-warning text-dark">{{ $product->stock }} in stock (Low)</span>
                                    @else
                                        <span class="badge bg-danger">Out of stock</span>
                                    @endif
                                </p>
                            </div>
                            
                            <div class="mb-3">
                                <h6 class="text-muted">Orders</h6>
                                <p>{{ $product->orders_count ?? 0 }} orders</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-4">
                        <h6 class="text-muted">Description</h6>
                        <p>{{ $product->description ?? 'No description available.' }}</p>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <h6 class="text-muted">Created At</h6>
                            <p>{{ $product->created_at->format('M d, Y H:i') }}</p>
                        </div>
                        
                        <div class="col-md-6">
                            <h6 class="text-muted">Last Updated</h6>
                            <p>{{ $product->updated_at->format('M d, Y H:i') }}</p>
                        </div>
                    </div>
                    
                    @if($product->specifications)
                        <div class="mb-4">
                            <h6 class="text-muted">Specifications</h6>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <tbody>
                                        @foreach(json_decode($product->specifications, true) ?? [] as $key => $value)
                                            <tr>
                                                <th style="width: 30%">{{ $key }}</th>
                                                <td>{{ $value }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <!-- Tabs Section -->
    <div class="card mb-4">
        <div class="card-body">
            <ul class="nav nav-tabs" id="productTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="reviews-tab" data-bs-toggle="tab" data-bs-target="#reviews" type="button" role="tab" aria-controls="reviews" aria-selected="true">
                        Reviews <span class="badge bg-primary">{{ count($product->reviews) }}</span>
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="orders-tab" data-bs-toggle="tab" data-bs-target="#orders" type="button" role="tab" aria-controls="orders" aria-selected="false">
                        Orders <span class="badge bg-primary">{{ $product->orders_count ?? 0 }}</span>
                    </button>
                </li>
            </ul>
            
            <div class="tab-content p-3" id="productTabsContent">
                <!-- Reviews Tab -->
                <div class="tab-pane fade show active" id="reviews" role="tabpanel" aria-labelledby="reviews-tab">
                    @if($product->reviews->isEmpty())
                        <div class="alert alert-info">
                            No reviews yet for this product.
                        </div>
                    @else
                        @foreach($product->reviews as $review)
                            <div class="card mb-3">
                                <div class="card-body">
                                    <div class="d-flex mb-3">
                                        @if($review->user && $review->user->avatar)
                                            <img src="{{ asset('storage/' . $review->user->avatar) }}" alt="{{ $review->user->name }}" class="review-avatar me-3">
                                        @else
                                            <div class="review-avatar bg-light d-flex align-items-center justify-content-center me-3">
                                                <i class="fas fa-user text-secondary"></i>
                                            </div>
                                        @endif
                                        
                                        <div>
                                            <h6 class="mb-0">{{ $review->user->name ?? 'Anonymous' }}</h6>
                                            <div class="star-rating">
                                                @for($i = 1; $i <= 5; $i++)
                                                    @if($i <= $review->rating)
                                                        <i class="fas fa-star"></i>
                                                    @else
                                                        <i class="far fa-star"></i>
                                                    @endif
                                                @endfor
                                            </div>
                                            <small class="text-muted">{{ $review->created_at->format('M d, Y') }}</small>
                                        </div>
                                        
                                        <div class="ms-auto">
                                            <form action="{{ route('admin.marketplace.reviews.destroy', $review->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this review?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                    
                                    <p>{{ $review->review }}</p>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                
                <!-- Orders Tab -->
                <div class="tab-pane fade" id="orders" role="tabpanel" aria-labelledby="orders-tab">
                    <div class="alert alert-info">
                        Order history for this product will be displayed here.
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Related Products -->
    @if(count($relatedProducts) > 0)
        <div class="card mb-4">
            <div class="card-header">
                <i class="fas fa-link me-1"></i>
                Related Products
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($relatedProducts as $relatedProduct)
                        <div class="col-md-3 mb-4">
                            <div class="card related-product-card h-100">
                                @if($relatedProduct->thumbnail)
                                    <img src="{{ asset('storage/' . $relatedProduct->thumbnail) }}" alt="{{ $relatedProduct->name }}" class="related-product-image">
                                @else
                                    <div class="related-product-image bg-light d-flex align-items-center justify-content-center">
                                        <i class="fas fa-image fa-2x text-secondary"></i>
                                    </div>
                                @endif
                                
                                <div class="card-body">
                                    <h6 class="card-title">{{ Str::limit($relatedProduct->name, 30) }}</h6>
                                    <p class="card-text text-primary">${{ number_format($relatedProduct->price, 2) }}</p>
                                    <a href="{{ route('admin.marketplace.products.show', $relatedProduct->id) }}" class="btn btn-sm btn-outline-primary">View Details</a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
    
    <!-- Status Modal -->
    <div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="statusModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="statusModalLabel">Update Product Status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('admin.marketplace.products.update-status', $product->id) }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <p>Update status for <strong>{{ $product->name }}</strong>:</p>
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="radio" name="status" id="statusActive" value="active" {{ $product->status == 'active' ? 'checked' : '' }}>
                            <label class="form-check-label" for="statusActive">
                                Active
                            </label>
                        </div>
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="radio" name="status" id="statusInactive" value="inactive" {{ $product->status == 'inactive' ? 'checked' : '' }}>
                            <label class="form-check-label" for="statusInactive">
                                Inactive
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="status" id="statusPending" value="pending" {{ $product->status == 'pending' ? 'checked' : '' }}>
                            <label class="form-check-label" for="statusPending">
                                Pending
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Status</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete <strong>{{ $product->name }}</strong>?</p>
                    <p class="text-danger">This action cannot be undone. All associated data will be permanently removed.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <form action="{{ route('admin.marketplace.products.destroy', $product->id) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">Delete Product</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    function changeMainImage(src, thumbnail) {
        document.getElementById('mainProductImage').src = src;
        
        // Remove active class from all thumbnails
        document.querySelectorAll('.product-thumbnail').forEach(thumb => {
            thumb.classList.remove('active');
        });
        
        // Add active class to clicked thumbnail
        thumbnail.classList.add('active');
    }
</script>
@endsection 