@extends('admin.layouts.home')

@section('title', 'Job Applications')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Applications for: {{ $job->job_title }}</h4>
                    <div>
                        <a href="{{ route('admin.jobs.show', $job->id) }}" class="btn btn-info btn-sm">
                            <i class="fas fa-eye"></i> View Job
                        </a>
                        <a href="{{ route('admin.jobs.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Jobs
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Applicant</th>
                                    <th>Email</th>
                                    <th>Applied On</th>
                                    <th>Resume</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($applications as $application)
                                    <tr>
                                        <td>{{ $application->id }}</td>
                                        <td>{{ $application->user->name ?? 'N/A' }}</td>
                                        <td>{{ $application->user->email ?? 'N/A' }}</td>
                                        <td>{{ $application->created_at->format('M d, Y') }}</td>
                                        <td>
                                            @if($application->resume_path)
                                                <a href="{{ Storage::url($application->resume_path) }}" target="_blank" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-file-pdf"></i> View Resume
                                                </a>
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $application->status == 'hired' ? 'success' : ($application->status == 'shortlisted' ? 'info' : ($application->status == 'rejected' ? 'danger' : 'warning')) }}">
                                                {{ ucfirst($application->status) }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Update Status
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li>
                                                        <form action="{{ route('admin.jobs.application.status', $application->id) }}" method="POST">
                                                            @csrf
                                                            @method('PUT')
                                                            <input type="hidden" name="status" value="pending">
                                                            <button type="submit" class="dropdown-item {{ $application->status == 'pending' ? 'active' : '' }}">Pending</button>
                                                        </form>
                                                    </li>
                                                    <li>
                                                        <form action="{{ route('admin.jobs.application.status', $application->id) }}" method="POST">
                                                            @csrf
                                                            @method('PUT')
                                                            <input type="hidden" name="status" value="shortlisted">
                                                            <button type="submit" class="dropdown-item {{ $application->status == 'shortlisted' ? 'active' : '' }}">Shortlisted</button>
                                                        </form>
                                                    </li>
                                                    <li>
                                                        <form action="{{ route('admin.jobs.application.status', $application->id) }}" method="POST">
                                                            @csrf
                                                            @method('PUT')
                                                            <input type="hidden" name="status" value="rejected">
                                                            <button type="submit" class="dropdown-item {{ $application->status == 'rejected' ? 'active' : '' }}">Rejected</button>
                                                        </form>
                                                    </li>
                                                    <li>
                                                        <form action="{{ route('admin.jobs.application.status', $application->id) }}" method="POST">
                                                            @csrf
                                                            @method('PUT')
                                                            <input type="hidden" name="status" value="hired">
                                                            <button type="submit" class="dropdown-item {{ $application->status == 'hired' ? 'active' : '' }}">Hired</button>
                                                        </form>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">No applications found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $applications->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 