@extends('admin.layouts.home')

@section('title', 'Help Center Topics')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Help Center Topics</h1>
            <p class="text-muted mb-0">Organize your support content into clear, themed topics.</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.help-center.articles.index') }}" class="btn btn-outline-primary btn-sm">
                <i class="fas fa-file-alt me-1"></i> Manage Articles
            </a>
            <a href="{{ route('admin.help-center.topics.create') }}" class="btn btn-primary btn-sm shadow-sm">
                <i class="fas fa-plus me-1"></i> New Topic
            </a>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Topic Library</h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Topic</th>
                            <th class="text-center">Articles</th>
                            <th class="text-center">Display Order</th>
                            <th>Status</th>
                            <th>Updated</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($topics as $topic)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if ($topic->icon)
                                            <span class="badge bg-primary bg-opacity-10 text-primary me-3 fs-5">
                                                <i class="{{ $topic->icon }}"></i>
                                            </span>
                                        @endif
                                        <div>
                                            <div class="fw-semibold">{{ $topic->title }}</div>
                                            <small class="text-muted">/{{ $topic->slug }}</small>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-secondary">{{ $topic->articles()->count() }}</span>
                                </td>
                                <td class="text-center">{{ $topic->display_order }}</td>
                                <td>
                                    @if ($topic->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-secondary">Hidden</span>
                                    @endif
                                </td>
                                <td>
                                    <small class="text-muted">{{ $topic->updated_at?->diffForHumans() ?? '—' }}</small>
                                </td>
                                <td class="text-end">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('admin.help-center.topics.edit', $topic) }}" class="btn btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.help-center.topics.destroy', $topic) }}" method="POST" onsubmit="return confirm('Delete this topic?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">
                                    <i class="fas fa-folder-open fa-2x mb-2 d-block"></i>
                                    <span>No help center topics yet. Start by creating one.</span>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if ($topics->hasPages())
            <div class="card-footer">
                {{ $topics->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
