@extends('admin.layouts.home')

@section('title', 'Help Center Articles')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Help Center Articles</h1>
            <p class="text-muted mb-0">Create step-by-step guides, FAQs, and troubleshooting docs for your community.</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.help-center.topics.create') }}" class="btn btn-outline-primary btn-sm">
                <i class="fas fa-layer-group me-1"></i> New Topic
            </a>
            <a href="{{ route('admin.help-center.articles.create') }}" class="btn btn-primary btn-sm shadow-sm">
                <i class="fas fa-plus me-1"></i> New Article
            </a>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-column flex-md-row justify-content-between align-items-md-center">
            <h6 class="m-0 font-weight-bold text-primary">Knowledge Articles</h6>
            <form method="GET" class="d-flex align-items-center mt-3 mt-md-0">
                <label for="topicFilter" class="me-2 mb-0">Filter by topic:</label>
                <select name="topic_id" id="topicFilter" class="form-select form-select-sm" onchange="this.form.submit()">
                    <option value="">All topics</option>
                    @foreach ($topics as $topic)
                        <option value="{{ $topic->id }}" {{ (string) $selectedTopicId === (string) $topic->id ? 'selected' : '' }}>
                            {{ $topic->title }}
                        </option>
                    @endforeach
                </select>
            </form>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Article</th>
                            <th>Topic</th>
                            <th class="text-center">Featured</th>
                            <th class="text-center">Published</th>
                            <th class="text-center">Read (min)</th>
                            <th class="text-center">Order</th>
                            <th>Updated</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($articles as $article)
                            <tr>
                                <td>
                                    <div class="fw-semibold">{{ $article->title }}</div>
                                    <small class="text-muted">/{{ $article->slug }}</small>
                                </td>
                                <td>
                                    <span class="badge bg-primary bg-opacity-10 text-primary">
                                        {{ $article->topic?->title ?? '—' }}
                                    </span>
                                </td>
                                <td class="text-center">
                                    @if ($article->is_featured)
                                        <i class="fas fa-star text-warning"></i>
                                    @else
                                        <span class="text-muted">—</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if ($article->is_published)
                                        <span class="badge bg-success">Published</span>
                                    @else
                                        <span class="badge bg-secondary">Draft</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    {{ $article->estimated_reading_time ?? '—' }}
                                </td>
                                <td class="text-center">{{ $article->display_order }}</td>
                                <td>
                                    <small class="text-muted">{{ $article->updated_at?->diffForHumans() ?? '—' }}</small>
                                </td>
                                <td class="text-end">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('admin.help-center.articles.edit', $article) }}" class="btn btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.help-center.articles.destroy', $article) }}" method="POST" onsubmit="return confirm('Delete this article?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-4 text-muted">
                                    <i class="fas fa-file-alt fa-2x mb-2 d-block"></i>
                                    <span>No help center articles found. Start by creating one.</span>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if ($articles->hasPages())
            <div class="card-footer">
                {{ $articles->appends(['topic_id' => $selectedTopicId])->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
