@extends('admin.layouts.home')

@section('title', 'Group Details')

@section('styles')
<style>
    .nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active {
        background-color: #f8f9fc;
        border-color: #dee2e6 #dee2e6 #f8f9fc;
    }
    .tab-content {
        border: 1px solid #dee2e6;
        border-top: none;
        padding: 20px;
        background-color: #f8f9fc;
    }
    .member-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
    }
    .post-content {
        white-space: pre-line;
    }
    .post-media img {
        max-width: 100%;
        height: auto;
        border-radius: 0.35rem;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Group Details</h1>
        <div>
            <a href="{{ route('admin.groups.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Groups
            </a>
        </div>
    </div>

    <!-- Group Info Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Group Information</h6>
            <div>
                @if($group->is_featured)
                    <form action="{{ route('admin.groups.toggle-featured', $group->id) }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-warning">
                            <i class="fas fa-star"></i> Remove from Featured
                        </button>
                    </form>
                @else
                    <form action="{{ route('admin.groups.toggle-featured', $group->id) }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-outline-warning">
                            <i class="far fa-star"></i> Add to Featured
                        </button>
                    </form>
                @endif

                @if($group->active)
                    <form action="{{ route('admin.groups.update-status', $group->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="active" value="0">
                        <button type="submit" class="btn btn-sm btn-danger">
                            <i class="fas fa-ban"></i> Deactivate Group
                        </button>
                    </form>
                @else
                    <form action="{{ route('admin.groups.update-status', $group->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="active" value="1">
                        <button type="submit" class="btn btn-sm btn-success">
                            <i class="fas fa-check"></i> Activate Group
                        </button>
                    </form>
                @endif

                <form action="{{ route('admin.groups.destroy', $group->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this group? This action cannot be undone.')">
                        <i class="fas fa-trash"></i> Delete Group
                    </button>
                </form>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-3 mb-4">
                    @if($group->cover_photo)
                        <img src="{{ asset('storage/'.$group->cover_photo) }}" class="img-fluid rounded shadow-sm" alt="{{ $group->name }}">
                    @else
                        <div class="bg-light rounded text-center py-5">
                            <i class="fas fa-users fa-4x text-gray-400"></i>
                            <p class="mt-2 text-gray-500">No Cover Image</p>
                        </div>
                    @endif
                </div>
                <div class="col-md-9">
                    <h4>{{ $group->name }} 
                        <span class="badge bg-{{ $group->privacy === 'public' ? 'success' : 'warning' }}">
                            <i class="fas {{ $group->privacy === 'public' ? 'fa-globe' : 'fa-lock' }}"></i> 
                            {{ ucfirst($group->privacy) }}
                        </span>
                        <span class="badge bg-{{ $group->active ? 'primary' : 'danger' }}">
                            {{ $group->active ? 'Active' : 'Inactive' }}
                        </span>
                        @if($group->is_featured)
                            <span class="badge bg-warning">
                                <i class="fas fa-star"></i> Featured
                            </span>
                        @endif
                    </h4>
                    
                    <p class="text-muted">{{ $group->description }}</p>
                    
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <p><strong>Category:</strong> 
                                <span class="badge bg-info">
                                    @if($group->category)
                                        @if($group->category->icon)
                                            <i class="fas {{ $group->category->icon }}"></i>
                                        @endif
                                        {{ $group->category->name }}
                                    @else
                                        Uncategorized
                                    @endif
                                </span>
                            </p>
                            <p><strong>Created:</strong> {{ $group->created_at->format('M d, Y') }}</p>
                            <p><strong>Creator:</strong> 
                                <a href="{{ url('admin/users', $group->creator_id) }}">
                                    {{ $group->creator->name ?? 'Unknown User' }}
                                </a>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Total Members:</strong> {{ $memberCount }}</p>
                            <p><strong>Total Posts:</strong> {{ $postCount }}</p>
                            <p><strong>Reports:</strong> 
                                @if($reportCount > 0)
                                    <span class="badge bg-danger">{{ $reportCount }} reports</span>
                                @else
                                    <span class="badge bg-success">No reports</span>
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabs Navigation -->
    <ul class="nav nav-tabs" id="groupTabs" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="members-tab" data-toggle="tab" href="#members" role="tab" aria-controls="members" aria-selected="true">
                <i class="fas fa-users"></i> Members ({{ $memberCount }})
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="posts-tab" data-toggle="tab" href="#posts" role="tab" aria-controls="posts" aria-selected="false">
                <i class="fas fa-file-alt"></i> Posts ({{ $postCount }})
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="reports-tab" data-toggle="tab" href="#reports" role="tab" aria-controls="reports" aria-selected="false">
                <i class="fas fa-flag"></i> Reports ({{ $reportCount }})
            </a>
        </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content" id="groupTabsContent">
        <!-- Members Tab -->
        <div class="tab-pane fade show active" id="members" role="tabpanel" aria-labelledby="members-tab">
            <div class="table-responsive">
                <table class="table table-bordered" id="membersTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Role</th>
                            <th>Joined</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($members as $member)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if($member->user->profile_photo)
                                        <img src="{{ asset('storage/'.$member->user->profile_photo) }}" class="member-avatar mr-2" alt="">
                                    @else
                                        <div class="bg-primary text-white rounded-circle mr-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                            {{ strtoupper(substr($member->user->name, 0, 1)) }}
                                        </div>
                                    @endif
                                    <div>
                                        <a href="{{ url('admin/users', $member->user_id) }}">
                                            {{ $member->user->name }}
                                        </a>
                                        <div class="small text-muted">{{ $member->user->email }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-{{ $member->role === 'admin' ? 'danger' : ($member->role === 'moderator' ? 'warning' : 'secondary') }}">
                                    {{ ucfirst($member->role) }}
                                </span>
                            </td>
                            <td>{{ $member->created_at->format('M d, Y') }}</td>
                            <td>
                                <span class="badge bg-{{ $member->status === 'approved' ? 'success' : ($member->status === 'pending' ? 'warning' : 'danger') }}">
                                    {{ ucfirst($member->status) }}
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Posts Tab -->
        <div class="tab-pane fade" id="posts" role="tabpanel" aria-labelledby="posts-tab">
            <div class="table-responsive">
                <table class="table table-bordered" id="postsTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Content</th>
                            <th>Author</th>
                            <th>Posted</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($posts as $post)
                        <tr>
                            <td>{{ $post->id }}</td>
                            <td>
                                <div class="post-content">{{ Str::limit($post->content, 100) }}</div>
                                @if($post->media)
                                    <div class="post-media mt-2">
                                        <small class="text-muted">Has media attachment</small>
                                    </div>
                                @endif
                                @if($post->is_pinned)
                                    <span class="badge bg-info mt-1">
                                        <i class="fas fa-thumbtack"></i> Pinned
                                    </span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ url('admin/users', $post->user_id) }}">
                                    {{ $post->user->name ?? 'Unknown User' }}
                                </a>
                            </td>
                            <td>{{ $post->created_at->format('M d, Y H:i') }}</td>
                            <td>
                                <span class="badge bg-{{ $post->status === 'published' ? 'success' : ($post->status === 'pending' ? 'warning' : 'danger') }}">
                                    {{ ucfirst($post->status) }}
                                </span>
                            </td>
                            <td>
                                @if($post->status === 'pending')
                                    <form action="{{ route('admin.posts.update-status', $post->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="status" value="published">
                                        <button type="submit" class="btn btn-sm btn-success">
                                            <i class="fas fa-check"></i> Approve
                                        </button>
                                    </form>
                                    <form action="{{ route('admin.posts.update-status', $post->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="status" value="rejected">
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="fas fa-times"></i> Reject
                                        </button>
                                    </form>
                                @endif
                                <form action="{{ route('admin.posts.delete', $post->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this post?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Reports Tab -->
        <div class="tab-pane fade" id="reports" role="tabpanel" aria-labelledby="reports-tab">
            @if($reports->isEmpty())
                <div class="alert alert-success" role="alert">
                    <i class="fas fa-check-circle"></i> This group has no reports.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-bordered" id="reportsTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Reported By</th>
                                <th>Reason</th>
                                <th>Details</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($reports as $report)
                            <tr>
                                <td>{{ $report->id }}</td>
                                <td>
                                    <a href="{{ url('admin/users', $report->user_id) }}">
                                        {{ $report->user->name ?? 'Unknown User' }}
                                    </a>
                                </td>
                                <td>{{ $report->reason }}</td>
                                <td>{{ Str::limit($report->details, 100) }}</td>
                                <td>{{ $report->created_at->format('M d, Y') }}</td>
                                <td>
                                    <span class="badge bg-{{ $report->status === 'pending' ? 'warning' : ($report->status === 'resolved' ? 'success' : 'secondary') }}">
                                        {{ ucfirst($report->status) }}
                                    </span>
                                </td>
                                <td>
                                    @if($report->status === 'pending')
                                        <form action="{{ route('admin.reports.update-status', $report->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('PUT')
                                            <input type="hidden" name="status" value="resolved">
                                            <button type="submit" class="btn btn-sm btn-success">
                                                <i class="fas fa-check"></i> Resolve
                                            </button>
                                        </form>
                                        <form action="{{ route('admin.reports.update-status', $report->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('PUT')
                                            <input type="hidden" name="status" value="dismissed">
                                            <button type="submit" class="btn btn-sm btn-warning">
                                                <i class="fas fa-ban"></i> Dismiss
                                            </button>
                                        </form>
                                    @endif
                                    <form action="{{ route('admin.reports.delete', $report->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this report?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('#membersTable').DataTable({
            "order": [[2, "desc"]]
        });
        
        $('#postsTable').DataTable({
            "order": [[3, "desc"]]
        });
        
        $('#reportsTable').DataTable({
            "order": [[4, "desc"]]
        });
        
        // Handle tab switching using URL hash
        var hash = window.location.hash;
        if (hash) {
            $('#groupTabs a[href="'+hash+'"]').tab('show');
        }
        
        // Change hash on tab click
        $('#groupTabs a').on('click', function(e) {
            window.location.hash = $(this).attr('href');
        });
    });
</script>
@endsection 