@extends('admin.layouts.home')

@section('title', 'Manage Games')

@section('content')
    <div class="container-fluid">
        <!-- Page Heading -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0 text-gray-800">Manage HTML5 Games</h1>
            <a href="{{ route('admin.games.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle mr-1"></i> Add New Game
            </a>
        </div>

        <!-- Game List Card -->
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-primary">Games List</h6>
                <div>
                    <form action="{{ route('admin.games.index') }}" method="GET" class="d-inline-flex">
                        <div class="input-group">
                            <input type="text" class="form-control" name="search" placeholder="Search games..."
                                value="{{ request('search') }}">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">
                                    <i class="bi bi-search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card-body">
                @if (session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th width="60">ID</th>
                                <th width="80">Thumbnail</th>
                                <th>Title</th>
                                <th>Category</th>
                                <th>Age</th>
                                <th>Status</th>
                                <th>Featured</th>
                                <th>Multiplayer</th>
                                <th>Plays</th>
                                <th width="120">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($games as $game)
                                <tr>
                                    <td>{{ $game->id }}</td>
                                    <td>
                                        @if ($game->thumbnail_url)
                                            <img src="{{ $game->thumbnail_url }}" alt="{{ $game->title }}"
                                                class="img-thumbnail" width="50">
                                        @else
                                            <div class="bg-light text-center p-2">
                                                <i class="bi bi-controller text-secondary"></i>
                                            </div>
                                        @endif
                                    </td>
                                    <td>{{ $game->title }}</td>
                                    <td>{{ $game->category->name }}</td>
                                    <td>{{ $game->min_age }}+</td>
                                    <td>
                                        @if ($game->is_active)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-secondary">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($game->is_featured)
                                            <span class="badge bg-warning">Featured</span>
                                        @else
                                            <span class="badge bg-light">No</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($game->is_multiplayer)
                                            <span class="badge bg-info">Yes</span>
                                        @else
                                            <span class="badge bg-light">No</span>
                                        @endif
                                    </td>
                                    <td>{{ number_format($game->plays_count) }}</td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.games.edit', $game) }}"
                                                class="btn btn-sm btn-primary">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <a href="{{ route('games.show', $game->slug) }}" class="btn btn-sm btn-info"
                                                target="_blank">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <form action="{{ route('admin.games.destroy', $game) }}" method="POST"
                                                class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger"
                                                    onclick="return confirm('Are you sure you want to delete this game?')">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="10" class="text-center">No games found</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    {{ $games->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection
