@extends('admin.layouts.home')

@section('title', 'Add New Game')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add New HTML5 Game</h1>
        <a href="{{ route('admin.games.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left mr-1"></i> Back to Games
        </a>
    </div>

    <!-- Game Form Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Game Information</h6>
        </div>
        <div class="card-body">
            @if($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form action="{{ route('admin.games.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-8">
                        <!-- Basic Information -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="mb-0">Basic Information</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="title">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required>
                                </div>
                                <div class="form-group">
                                    <label for="description">Description <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="description" name="description" rows="5" required>{{ old('description') }}</textarea>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="category_id">Category <span class="text-danger">*</span></label>
                                            <select class="form-control" id="category_id" name="category_id" required>
                                                <option value="">Select Category</option>
                                                @foreach($categories as $category)
                                                <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                                    {{ $category->name }}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="min_age">Minimum Age <span class="text-danger">*</span></label>
                                            <select class="form-control" id="min_age" name="min_age" required>
                                                <option value="">Select Age Rating</option>
                                                <option value="3" {{ old('min_age') == '3' ? 'selected' : '' }}>3+</option>
                                                <option value="5" {{ old('min_age') == '5' ? 'selected' : '' }}>5+</option>
                                                <option value="7" {{ old('min_age') == '7' ? 'selected' : '' }}>7+</option>
                                                <option value="10" {{ old('min_age') == '10' ? 'selected' : '' }}>10+</option>
                                                <option value="13" {{ old('min_age') == '13' ? 'selected' : '' }}>13+</option>
                                                <option value="16" {{ old('min_age') == '16' ? 'selected' : '' }}>16+</option>
                                                <option value="18" {{ old('min_age') == '18' ? 'selected' : '' }}>18+</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Game Embed -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="mb-0">Game Embed</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="game_url">Game URL <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="game_url" name="game_url" value="{{ old('game_url') }}" required>
                                    <small class="form-text text-muted">Enter the URL of the HTML5 game. This should be a direct link to the game file or embed URL.</small>
                                </div>
                                <div class="alert alert-info">
                                    <i class="bi bi-info-circle mr-2"></i>
                                    <strong>Note:</strong> Make sure the game URL is from a trusted source and the game is compatible with iframe embedding.
                                </div>
                            </div>
                        </div>

                        <!-- Game Instructions -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="mb-0">Game Instructions</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="instructions">How to Play</label>
                                    <textarea class="form-control" id="instructions" name="instructions" rows="5">{{ old('instructions') }}</textarea>
                                    <small class="form-text text-muted">Provide clear instructions on how to play the game, including controls and objectives.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <!-- Thumbnail Upload -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="mb-0">Game Thumbnail</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="thumbnail">Upload Thumbnail</label>
                                    <input type="file" class="form-control-file" id="thumbnail" name="thumbnail" accept="image/jpeg,image/png,image/jpg">
                                    <small class="form-text text-muted">Recommended size: 400x300 pixels. Max file size: 2MB.</small>
                                </div>
                                <div class="mt-3 text-center">
                                    <div class="img-thumbnail p-2" style="height: 150px; width: 200px; margin: 0 auto;">
                                        <div class="d-flex align-items-center justify-content-center h-100 bg-light">
                                            <i class="bi bi-image text-secondary" style="font-size: 3rem;"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Settings -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h6 class="mb-0">Game Settings</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_active">Active</label>
                                    </div>
                                    <small class="form-text text-muted">If enabled, this game will be visible to users.</small>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_featured" name="is_featured" value="1" {{ old('is_featured') == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_featured">Featured</label>
                                    </div>
                                    <small class="form-text text-muted">If enabled, this game will be highlighted in featured sections.</small>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_multiplayer" name="is_multiplayer" value="1" {{ old('is_multiplayer') == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_multiplayer">Multiplayer</label>
                                    </div>
                                    <small class="form-text text-muted">Enable if this game supports multiplayer functionality.</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="text-center mt-4">
                    <button type="submit" class="btn btn-primary btn-lg px-5">
                        <i class="bi bi-save mr-2"></i> Save Game
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Preview uploaded image
    document.getElementById('thumbnail').onchange = function(e) {
        const preview = document.querySelector('.img-thumbnail');
        const file = e.target.files[0];
        
        if (file) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                preview.innerHTML = `<img src="${e.target.result}" class="h-100" style="object-fit: contain;">`;
            }
            
            reader.readAsDataURL(file);
        }
    };
</script>
@endpush
