@extends('admin.layouts.home')

@section('title', $blog->title)

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ $blog->title }}</h1>
        <div>
            <a href="{{ route('admin.blogs.edit', $blog) }}" class="btn btn-primary">
                <i class="bi bi-pencil mr-1"></i> {{ __('Edit') }}
            </a>
            <a href="{{ route('admin.blogs.index') }}" class="btn btn-secondary ml-2">
                <i class="bi bi-arrow-left mr-1"></i> {{ __('Back to Blogs') }}
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <!-- Blog Content Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Blog Content') }}</h6>
                    <span class="badge {{ $blog->active ? 'bg-success' : 'bg-secondary' }}">
                        {{ $blog->active ? __('Published') : __('Draft') }}
                    </span>
                </div>
                <div class="card-body">
                    @if($blog->thumbnail)
                    <div class="text-center mb-4">
                        <img src="{{ asset('storage/' . $blog->thumbnail) }}" alt="{{ $blog->title }}" class="img-fluid rounded" style="max-height: 400px;">
                    </div>
                    @endif
                    
                    <div class="mb-4">
                        <h5 class="font-weight-bold">Description</h5>
                        <p>{{ $blog->description }}</p>
                    </div>
                    
                    <div>
                        <h5 class="font-weight-bold">Content</h5>
                        <div class="blog-content">
                            {!! $blog->content !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <!-- Blog Details Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Blog Details</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Author</h6>
                        <p>{{ $blog->user->name ?? 'Unknown' }}</p>
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Category</h6>
                        <span class="badge bg-info">
                            {{ $blog->category ? $blog->category->name : 'Uncategorized' }}
                        </span>
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Type</h6>
                        <p>{{ $blog->type ?? 'blog' }}</p>
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Featured</h6>
                        @if($blog->is_featured)
                            <span class="badge bg-warning">Yes</span>
                        @else
                            <span class="badge bg-secondary">No</span>
                        @endif
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Hits</h6>
                        <p>{{ $blog->hits ?? 0 }}</p>
                    </div>
                    
                    @if($blog->published_at)
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Published At</h6>
                        <p>{{ $blog->published_at->format('M d, Y H:i') }}</p>
                    </div>
                    @endif
                    
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Created</h6>
                        <p>{{ $blog->created_at->format('M d, Y H:i') }}</p>
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Last Updated</h6>
                        <p>{{ $blog->updated_at->format('M d, Y H:i') }}</p>
                    </div>
                    
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Slug</h6>
                        <p class="text-muted">{{ $blog->slug }}</p>
                    </div>
                    
                    @if($blog->meta_title || $blog->meta_description || $blog->meta_keywords)
                    <div class="mt-4">
                        <h6 class="font-weight-bold">SEO Information</h6>
                        @if($blog->meta_title)
                            <div class="mb-2">
                                <small class="text-muted">Meta Title:</small>
                                <p class="mb-0">{{ $blog->meta_title }}</p>
                            </div>
                        @endif
                        @if($blog->meta_description)
                            <div class="mb-2">
                                <small class="text-muted">Meta Description:</small>
                                <p class="mb-0">{{ $blog->meta_description }}</p>
                            </div>
                        @endif
                        @if($blog->meta_keywords)
                            <div class="mb-2">
                                <small class="text-muted">Meta Keywords:</small>
                                <p class="mb-0">{{ $blog->meta_keywords }}</p>
                            </div>
                        @endif
                    </div>
                    @endif
                    
                    <div class="mt-4">
                        <form action="{{ route('admin.blogs.destroy', $blog) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this blog?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-block">
                                <i class="bi bi-trash mr-1"></i> Delete Blog
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<style>
.blog-content img {
    max-width: 100%;
    height: auto;
}
</style>