@extends('admin.layouts.home')

@section('title', __('Manage Blogs'))

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ __('Manage Blogs') }}</h1>
        <a href="{{ route('admin.blogs.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle mr-1"></i> {{ __('Add New Blog') }}
        </a>
    </div>

    <!-- Blog List Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Blogs List') }}</h6>
            <div>
                <form action="{{ route('admin.blogs.index') }}" method="GET" class="d-inline-flex">
                    <div class="input-group">
                        <input type="text" class="form-control" name="search" placeholder="{{ __('Search blogs...') }}" value="{{ request('search') }}">
                        <div class="input-group-append">
                            <button class="btn btn-primary" type="submit">
                                <i class="bi bi-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="card-body">
            @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif

            @if(session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>{{ __('ID') }}</th>
                            <th>{{ __('Title') }}</th>
                            <th>{{ __('Category') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Featured') }}</th>
                            <th>{{ __('Hits') }}</th>
                            <th>{{ __('Created') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($blogs as $blog)
                        <tr>
                            <td>{{ $blog->id }}</td>
                            <td>{{ $blog->title }}</td>
                            <td>
                                @if($blog->category)
                                    {{ $blog->category }}
                                @else
                                    <span class="text-muted">{{ __('Uncategorized') }}</span>
                                @endif
                            </td>
                            <td>
                                @if($blog->active)
                                    <span class="badge bg-success">{{ $blog->status ?? 'Published' }}</span>
                                @else
                                    <span class="badge bg-secondary">{{ __('Draft') }}</span>
                                @endif
                            </td>
                            <td>
                                @if($blog->is_featured)
                                    <span class="badge bg-warning">{{ __('Featured') }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>{{ $blog->hits ?? 0 }}</td>
                            <td>{{ $blog->created_at->format('M d, Y') }}</td>
                            <td>
                                <a href="{{ route('admin.blogs.show', $blog->id) }}" class="btn btn-sm btn-primary" title="{{ __('View') }}">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.blogs.edit', $blog->id) }}" class="btn btn-sm btn-info" title="{{ __('Edit') }}">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.blogs.destroy', $blog->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('{{ __('Are you sure you want to delete this blog?') }}')" title="{{ __('Delete') }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center">{{ __('No blogs found') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $blogs->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection