<nav class="navbar navbar-expand navbar-light navbar-bg">
    <a class="sidebar-toggle js-sidebar-toggle">
        <i class="hamburger align-self-center"></i>
    </a>
    <a href="{{ url('/') }}" class="btn btn-sm btn-primary" target="_blank" title="Visit Frontend">
        <i class="fas fa-globe"></i> {{ __('Visit Website') }}
    </a>

    <div class="navbar-collapse ms-auto  collapse">
        <ul class="navbar-nav navbar-align">
            <li class="nav-item dropdown ">
                <a class="nav-icon dropdown-toggle" href="#" id="alertsDropdown" data-bs-toggle="dropdown">
                    <div class="position-relative">
                        <i class="bi bi-bell align-middle"></i>
                        <span class="indicator">4</span>
                    </div>
                </a>
                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end py-0"
                    aria-labelledby="alertsDropdown">
                    <div class="dropdown-menu-header">
                        <div class="position-relative">
                            <i class="bi bi-bell-fill me-2"></i> {{ __('Notifications') }}
                        </div>
                    </div>
                    <div class="list-group">
                        <a href="#" class="list-group-item">
                            <div class="row g-0 align-items-center">
                                <div class="col-2 text-center">
                                    <div class="rounded-circle bg-light p-1">
                                        <i class="bi bi-check-circle-fill text-success"></i>
                                    </div>
                                </div>
                                <div class="col-10">
                                    <div class="text-dark fw-bold">{{ __('Update completed') }}</div>
                                    <div class="text-muted small mt-1">{{ __('Restart server to complete update') }}
                                    </div>
                                    <div class="text-muted small mt-1">{{ __(':time ago', ['time' => '30m']) }}</div>
                                </div>
                            </div>
                        </a>
                        <a href="#" class="list-group-item">
                            <div class="row g-0 align-items-center">
                                <div class="col-2 text-center">
                                    <div class="rounded-circle bg-light p-1">
                                        <i class="bi bi-person-fill text-primary"></i>
                                    </div>
                                </div>
                                <div class="col-10">
                                    <div class="text-dark fw-bold">{{ __('New user registered') }}</div>
                                    <div class="text-muted small mt-1">{{ __('User ":user" has joined', ['user' => 'johndoe']) }}</div>
                                    <div class="text-muted small mt-1">2h ago</div>
                                </div>
                            </div>
                        </a>
                        <a href="#" class="list-group-item">
                            <div class="row g-0 align-items-center">
                                <div class="col-2 text-center">
                                    <div class="rounded-circle bg-light p-1">
                                        <i class="bi bi-hdd-fill text-warning"></i>
                                    </div>
                                </div>
                                <div class="col-10">
                                    <div class="text-dark fw-bold">Server at capacity</div>
                                    <div class="text-muted small mt-1">Database server is at 80% capacity.
                                    </div>
                                    <div class="text-muted small mt-1">5h ago</div>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="dropdown-menu-footer">
                        <a href="#">View all notifications</a>
                    </div>
                </div>
            </li>
            <li class="nav-item dropdown">
                <a class="nav-icon dropdown-toggle" href="#" id="messagesDropdown"
                    data-bs-toggle="dropdown">
                    <div class="position-relative">
                        <i class="bi bi-chat-left-text align-middle"></i>
                        <span class="indicator">3</span>
                    </div>
                </a>
                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end py-0"
                    aria-labelledby="messagesDropdown">
                    <div class="dropdown-menu-header">
                        <div class="position-relative">
                            <i class="bi bi-chat-square-text-fill me-2"></i> Messages
                        </div>
                    </div>
                    <div class="list-group">
                        <a href="#" class="list-group-item">
                            <div class="row g-0 align-items-center">
                                <div class="col-2">
                                    <img src="/api/placeholder/40/40"
                                        class="avatar img-fluid rounded-circle" alt="User">
                                </div>
                                <div class="col-10 ps-2">
                                    <div class="text-dark fw-bold">Ashley Briggs</div>
                                    <div class="text-muted small mt-1">Nam pretium turpis et arcu. Duis
                                        arcu.</div>
                                    <div class="text-muted small mt-1">15m ago</div>
                                </div>
                            </div>
                        </a>
                        <a href="#" class="list-group-item">
                            <div class="row g-0 align-items-center">
                                <div class="col-2">
                                    <img src="/api/placeholder/40/40"
                                        class="avatar img-fluid rounded-circle" alt="User">
                                </div>
                                <div class="col-10 ps-2">
                                    <div class="text-dark fw-bold">Carl Jenkins</div>
                                    <div class="text-muted small mt-1">Curabitur ligula sapien, tincidunt
                                        non.</div>
                                    <div class="text-muted small mt-1">2h ago</div>
                                </div>
                            </div>
                        </a>
                        <a href="#" class="list-group-item">
                            <div class="row g-0 align-items-center">
                                <div class="col-2">
                                    <img src="/api/placeholder/40/40"
                                        class="avatar img-fluid rounded-circle" alt="User">
                                </div>
                                <div class="col-10 ps-2">
                                    <div class="text-dark fw-bold">Stacie Hall</div>
                                    <div class="text-muted small mt-1">Pellentesque auctor neque nec urna.
                                    </div>
                                    <div class="text-muted small mt-1">4h ago</div>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="dropdown-menu-footer">
                        <a href="#">View all messages</a>
                    </div>
                </div>
            </li>
            <li class="nav-item dropdown">
                <a class="nav-icon dropdown-toggle d-inline-block d-sm-none" href="#"
                    data-bs-toggle="dropdown">
                    <i class="bi bi-three-dots align-middle"></i>
                </a>

                @php($adminUser = auth()->user())
                <a class="nav-link dropdown-toggle d-none d-sm-inline-block" href="#"
                    data-bs-toggle="dropdown">
                    <img src="{{ optional($adminUser)->profile_photo ?? asset('assets/images/default-avatar.png') }}"
                        class="avatar img-fluid rounded-circle me-1"
                        alt="{{ optional($adminUser)->name ?? __('Admin User') }}" />
                    <span class="text-dark fw-bold">{{ optional($adminUser)->name ?? __('Admin User') }}</span>
                </a>
                <div class="dropdown-menu dropdown-menu-end">
                    <a class="dropdown-item" href="{{ route('settings.profile') }}">
                        <i class="bi bi-person me-2"></i> Profile
                    </a>
                    <a class="dropdown-item" href="{{ url('admin/eneral_settings') }}">
                        <i class="bi bi-gear me-2"></i> Settings
                    </a>
                    <a class="dropdown-item" href="{{ url('admin/dashboard') }}">
                        <i class="bi bi-bar-chart-line me-2"></i> Analytics
                    </a>
                    <div class="dropdown-divider"></div>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="dropdown-item">
                            <i class="bi bi-box-arrow-right me-2"></i> Log out
                        </button>
                    </form>
                </div>
            </li>
        </ul>
    </div>
</nav>
