<?php

namespace Database\Seeders;

use App\Models\RewardSetting;
use Illuminate\Database\Seeder;

class RewardSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // Post actions
            [
                'action_type' => 'post_create',
                'reward_amount' => 0.10,
                'daily_limit' => 10,
                'monthly_limit' => 300,
                'is_active' => true,
                'description' => 'Reward for creating a new post',
            ],
            [
                'action_type' => 'post_like',
                'reward_amount' => 0.01,
                'daily_limit' => 50,
                'monthly_limit' => 1000,
                'is_active' => true,
                'description' => 'Reward when your post receives a like',
            ],
            [
                'action_type' => 'post_share',
                'reward_amount' => 0.05,
                'daily_limit' => 20,
                'monthly_limit' => 500,
                'is_active' => true,
                'description' => 'Reward when your post is shared',
            ],
            
            // Comment actions
            [
                'action_type' => 'comment_create',
                'reward_amount' => 0.02,
                'daily_limit' => 25,
                'monthly_limit' => 500,
                'is_active' => true,
                'description' => 'Reward for creating a comment',
            ],
            [
                'action_type' => 'comment_like',
                'reward_amount' => 0.005,
                'daily_limit' => 100,
                'monthly_limit' => 2000,
                'is_active' => true,
                'description' => 'Reward when your comment receives a like',
            ],
            
            // Profile actions
            [
                'action_type' => 'profile_complete',
                'reward_amount' => 0.50,
                'daily_limit' => 1,
                'monthly_limit' => 1,
                'is_active' => true,
                'description' => 'One-time reward for completing your profile',
            ],
            [
                'action_type' => 'daily_login',
                'reward_amount' => 0.02,
                'daily_limit' => 1,
                'monthly_limit' => 30,
                'is_active' => true,
                'description' => 'Reward for daily login',
            ],
        ];

        foreach ($settings as $setting) {
            RewardSetting::create($setting);
        }
    }
} 