<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add user_role column after blood_type
            $table->enum('user_role', ['user', 'admin'])
                ->default('user')
                ->after('blood_type')
                ->comment('User role: user or admin');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop user_role column
            $table->dropColumn('user_role');
        });
    }
};
