<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_privacy_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->enum('profile_visibility', ['public', 'friends', 'private'])->default('public');
            $table->enum('friend_list_visibility', ['public', 'friends', 'private'])->default('public');
            $table->enum('post_visibility', ['public', 'friends', 'followers', 'private'])->default('public');
            $table->enum('message_privacy', ['everyone', 'friends', 'friends_of_friends', 'nobody'])->default('everyone');
            $table->enum('friend_request_privacy', ['everyone', 'friends_of_friends', 'nobody'])->default('everyone');
            $table->enum('wall_posts_privacy', ['everyone', 'friends', 'nobody'])->default('everyone');
            $table->boolean('chat_enabled')->default(true);
            $table->boolean('newsletter_enabled')->default(true);
            $table->boolean('search_engine_visibility')->default(false);
            $table->boolean('discoverable_by_contact')->default(true);
            $table->boolean('personalized_ads')->default(true);
            $table->boolean('data_collection')->default(true);
            $table->timestamps();

            $table->unique('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_privacy_settings');
    }
};
