<?php

namespace Database\Factories\Messenger;

use App\Models\Messenger\Message;
use App\Models\Messenger\Conversation;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class MessageFactory extends Factory
{
    protected $model = Message::class;

    public function definition(): array
    {
        return [
            'conversation_id' => Conversation::factory(),
            'user_id' => User::factory(),
            'type' => $this->faker->randomElement(['text', 'image', 'video', 'audio', 'file']),
            'content' => $this->faker->optional(0.9)->paragraph(),
            'client_generated_id' => $this->faker->uuid(),
            'reply_to_message_id' => null,
            'is_deleted' => false,
        ];
    }

    public function text(): static
    {
        return $this->state(fn (array $attributes) => [
            'type' => 'text',
            'content' => $this->faker->sentence(),
        ]);
    }

    public function image(): static
    {
        return $this->state(fn (array $attributes) => [
            'type' => 'image',
            'content' => $this->faker->optional(0.5)->sentence(),
        ]);
    }

    public function system(): static
    {
        return $this->state(fn (array $attributes) => [
            'type' => 'system',
            'content' => $this->faker->randomElement([
                'User joined the conversation',
                'User left the conversation',
                'Group name was changed',
                'User was added to the group',
                'User was removed from the group',
            ]),
        ]);
    }

    public function deleted(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_deleted' => true,
            'deleted_at' => $this->faker->dateTimeBetween('-1 week', 'now'),
            'content' => null,
        ]);
    }

    public function edited(): static
    {
        return $this->state(fn (array $attributes) => [
            'edited_at' => $this->faker->dateTimeBetween($attributes['created_at'] ?? '-1 day', 'now'),
        ]);
    }
}
