<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * Define your route model bindings, pattern filters, and other route configurations.
     */
    public function boot()
    {
        parent::boot(); // Ensure any required parent functionality is retained
    }

    /**
     * Define the routes for the application.
     */
    public function map()
    {
        $this->mapApiRoutes(); // Map API routes
        $this->mapWebRoutes(); // Map web routes
    }

    /**
     * Map the API routes.
     */
    protected function mapApiRoutes()
    {
        Route::prefix('api') // API prefix
            ->middleware('api') // API middleware for rate limiting and headers
            ->namespace($this->namespace . '\Api') // Ensure namespace includes the API directory
            ->group(base_path('routes/api.php')); // Path to the api.php routes file
    }

    /**
     * Map the web routes.
     */
    protected function mapWebRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace) // Standard namespace for web routes
            ->group(base_path('routes/web.php')); // Path to the web.php routes file
    }
}
