<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserReport extends Model
{
    use HasFactory;
    #table name
    protected $table = 'user_reports';

    protected $fillable = ['user_id', 'report_user_id', 'reason', 'status'];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the user who reported.
     */
    public function reportingUser()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get the reported user.
     */
    public function reportedUser()
    {
        return $this->belongsTo(User::class, 'report_user_id');
    }
    
    /**
     * Scope a query to only include pending reports.
     */
    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    /**
     * Scope a query to only include resolved reports.
     */
    public function scopeResolved($query)
    {
        return $query->where('status', 'resolved');
    }

    /**
     * Scope a query to only include dismissed reports.
     */
    public function scopeDismissed($query)
    {
        return $query->where('status', 'dismissed');
    }
}
