<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserPrivacySetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'profile_visibility',
        'friend_list_visibility',
        'post_visibility',
        'message_privacy',
        'friend_request_privacy',
        'wall_posts_privacy',
        'chat_enabled',
        'newsletter_enabled',
        'search_engine_visibility',
        'discoverable_by_contact',
        'personalized_ads',
        'data_collection',
    ];

    protected $casts = [
        'chat_enabled' => 'boolean',
        'newsletter_enabled' => 'boolean',
        'search_engine_visibility' => 'boolean',
        'discoverable_by_contact' => 'boolean',
        'personalized_ads' => 'boolean',
        'data_collection' => 'boolean',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
