<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReportSpace extends Model
{
    use HasFactory,SoftDeletes;
    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function space()
    {
        return $this->belongsTo(Space::class, 'space_id');
    }
    public function checkReport($user_id,$space_id)
    {
        return (!empty($this->where(['user_id'=>$user_id,'space_id'=>$space_id])->first())?1:0);
    }
    
}
