<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PollVote extends Model
{
    use HasFactory;

    protected $fillable = ['poll_id', 'option_id', 'user_id'];

    public function poll()
    {
        return $this->belongsTo(Poll::class);
    }

    public function option()
    {
        // Explicitly define foreign key
        return $this->belongsTo(PollOption::class, 'option_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}