<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Package extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'color',
        'description',
        'package_price',
        'duration',
        'status',
        'verified_badge',
        'edit_post',
        'business_page',
        'space_limit',
        'product_limit',
        'withdraw_limit',
        'job_limit',
        'course_limit',
        'event_limit'
    ];

    protected $casts = [
        'package_price' => 'double',
        'withdraw_limit' => 'double',
        'verified_badge' => 'boolean',
        'edit_post' => 'boolean',
        'business_page' => 'boolean',
        'space_limit' => 'integer',
        'product_limit' => 'integer',
        'job_limit' => 'integer',
        'course_limit' => 'integer',
        'event_limit' => 'integer',
    ];
}
