<?php
namespace App\Models\Movies;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;

class WatchHistory extends Model
{
    use HasFactory;
    protected $table = 'movies_watch_history';
    protected $fillable = [
        'user_id',
        'movie_id',
        'watched_time',
        'completed',
        'last_watched_at'
    ];

    protected $casts = [
        'completed' => 'boolean',
        'last_watched_at' => 'datetime'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function movie()
    {
        return $this->belongsTo(Movie::class);
    }
}