<?php
// app/Models/Genre.php
namespace App\Models\Movies;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Genre extends Model
{
    use HasFactory;
    protected $table = 'movies_genres';
    protected $fillable = [
        'name',
        'slug',
        'icon',
        'description',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function movies()
    {
        return $this->hasMany(Movie::class);
    }

    // Get movie count for this genre
    public function getMoviesCountAttribute()
    {
        return $this->movies()->count();
    }
}