<?php

namespace App\Models\Messenger;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Builder;

class MessageReceipt extends Model
{
    protected $fillable = [
        'message_id',
        'user_id',
        'type',
        'receipt_at',
    ];

    protected $casts = [
        'receipt_at' => 'datetime',
    ];

    public function message(): BelongsTo
    {
        return $this->belongsTo(Message::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function scopeDelivered(Builder $query): Builder
    {
        return $query->where('type', 'delivered');
    }

    public function scopeSeen(Builder $query): Builder
    {
        return $query->where('type', 'seen');
    }

    public function scopeForUser(Builder $query, int $userId): Builder
    {
        return $query->where('user_id', $userId);
    }

    public function scopeForMessage(Builder $query, int $messageId): Builder
    {
        return $query->where('message_id', $messageId);
    }
}
