<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HashTag extends Model
{
    use SoftDeletes;

    protected $table = 'hash_tags';

    protected $fillable = [
        'name',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    
    public function posts()
    {
        return $this->belongsToMany(Post::class, 'post_hashtags');
    }
    public function postTags()
{
    return $this->hasMany(PostTag::class, 'hashtag_id');
}
}