<?php
namespace App\Models\Games;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class GamePlayHistory extends Model
{
    use HasFactory;
    protected $table = 'game_play_history';
    protected $fillable = [
        'user_id',
        'game_id',
        'play_time',
        'last_played_at'
    ];

    protected $casts = [
        'last_played_at' => 'datetime'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function game()
    {
        return $this->belongsTo(Game::class);
    }
}
