<?php
namespace App\Models\Games;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GameCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'icon',
        'description',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function games()
    {
        return $this->hasMany(Game::class, 'category_id');
    }

    // Get games count for this category
    public function getGamesCountAttribute()
    {
        return $this->games()->count();
    }
}