<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Follower extends Model
{
    use HasFactory;

    protected $fillable = [
        'follower_id',
        'following_id',
        'active',
    ];

    /**
     * Check if a user is following another user.
     *
     * @param int $followerId
     * @param int $followingId
     * @return bool
     */
    public static function isFollowing($followerId, $followingId)
    {
        return self::where('follower_id', $followerId)
                    ->where('following_id', $followingId)
                    ->exists();
    }
}
