<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventParticipant extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id', 
        'user_id', 
        'status', 
        'approved',
        'is_host',
        'notes'
    ];

    protected $casts = [
        'approved' => 'boolean',
        'is_host' => 'boolean',
    ];

    /**
     * The event that this participant belongs to
     */
    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    /**
     * The user who is participating
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Scope a query to only include approved participants.
     */
    public function scopeApproved($query)
    {
        return $query->where('approved', true);
    }

    /**
     * Scope a query to only include pending participants.
     */
    public function scopePending($query)
    {
        return $query->where('approved', false);
    }

    /**
     * Scope a query to only include participants who are going.
     */
    public function scopeGoing($query)
    {
        return $query->where('status', 'going');
    }

    /**
     * Scope a query to only include participants who are interested.
     */
    public function scopeInterested($query)
    {
        return $query->where('status', 'interested');
    }

    /**
     * Scope a query to only include host participants.
     */
    public function scopeHosts($query)
    {
        return $query->where('is_host', true);
    }
}
