<?php

namespace App\Models\BloodBank;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BloodInventory extends Model
{
    use HasFactory;

    protected $fillable = [
        'blood_bank_id',
        'blood_type',
        'units_available',
        'is_low_stock',
        'is_critical'
    ];

    public function bloodBank()
    {
        return $this->belongsTo(BloodBank::class);
    }

    // Update stock status based on units
    public function updateStockStatus()
    {
        $this->is_critical = $this->units_available <= 5;
        $this->is_low_stock = $this->units_available <= 10 && $this->units_available > 5;
        $this->save();
    }
}