<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'description' => $this->description,
            'type' => $this->type,
            'media_url' => $this->media ? url("storage/{$this->media}") : null,
            'thumbnail_url' => $this->thumbnail ? url("storage/{$this->thumbnail}") : null,
            'duration' => $this->duration,
            'created_at' => $this->created_at,
            'user' => $this->user ? [
                'id' => $this->user->id,
                'name' => $this->user->name,
            ] : null,
        ];
    }
}
