<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {
        return [
            'id'=>$this->id,
            'from_user_id'=>$this->from_user_id,
            'to_user_id'=>$this->to_user_id,
            'type'=>$this->type,
            'text'=>$this->text,
            'post_id'=>$this->post_id,
            'page_id'=>$this->page_id,
            'group_id'=>$this->group_id,
            'space_id'=>$this->space_id,
            'seen'=>$this->seen,
            'is_reacted'=>$this->is_reacted,
            'created_at'=>$this->created_at,
            'notifier'=>new UserShortResource($this->sender)
        ];

    }
}
