<?php

namespace App\Http\Resources\Messenger;

use App\Http\Resources\UserShortResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ConversationParticipantResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'user' => new UserShortResource($this->whenLoaded('user')),
            'role' => $this->role,
            'joined_at' => $this->joined_at?->toISOString(),
            'last_seen_at' => $this->last_seen_at?->toISOString(),
            'is_muted' => $this->isMuted(),
            'muted_until' => $this->muted_until?->toISOString(),
        ];
    }
}
