<?php

namespace App\Http\Resources\Courses;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\UserShortResource;

class CourseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'slug' => $this->slug,
            'description' => $this->description,
            'requirements' => $this->requirements,
            'what_you_will_learn' => $this->what_you_will_learn,
            'target_audience' => $this->target_audience,
            'price' => $this->price,
            'discount_price' => $this->discount_price,
            'discount_ends_at' => $this->discount_ends_at,
            'level' => $this->level,
            'language' => $this->language,
            'thumbnail' => $this->thumbnail ? asset('storage/' . $this->thumbnail) : null,
            'preview_video' => $this->preview_video,
            'is_featured' => $this->is_featured,
            'is_published' => $this->is_published,
            'average_rating' => $this->average_rating,
            'total_reviews' => $this->total_reviews,
            'total_students' => $this->total_students,
            'total_lessons' => $this->total_lessons,
            'total_duration' => $this->total_duration,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'instructor' => $this->when($this->instructor, new UserShortResource($this->instructor)),
            'category' => $this->when($this->category, function() {
                return [
                    'id' => $this->category->id,
                    'name' => $this->category->name,
                    'slug' => $this->category->slug,
                ];
            }),
            'current_price' => $this->getCurrentPrice(),
            'has_discount' => $this->hasDiscount(),
            'discount_percentage' => $this->getDiscountPercentage(),
            'is_free' => $this->isFree(),
        ];
    }
} 