<?php

namespace App\Http\Resources\Courses;

use App\Http\Resources\UserShortResource;

class CourseDetailResource extends CourseResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data = parent::toArray($request);
        
        return array_merge($data, [
            'sections' => $this->when($this->sections, function() {
                return CourseSectionResource::collection($this->sections);
            }),
            'reviews' => $this->when($this->reviews, function() {
                return CourseReviewResource::collection($this->reviews);
            }),
        ]);
    }
} 