<?php
namespace App\Http\Resources\BloodBank;

use App\Http\Resources\UserShortResource;
use Illuminate\Http\Resources\Json\JsonResource;

class DriveRegistrationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'blood_drive_id' => $this->blood_drive_id,
            'blood_drive' => new BloodDriveResource($this->whenLoaded('bloodDrive')),
            'user_id' => $this->user_id,
            'user' => new UserShortResource($this->whenLoaded('user')),
            'name' => $this->name,
            'phone' => $this->phone,
            'email' => $this->email,
            'blood_type' => $this->blood_type,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
