<?php
namespace App\Http\Resources\BloodBank;

use Illuminate\Http\Resources\Json\JsonResource;

class BloodInventoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'blood_bank_id' => $this->blood_bank_id,
            'blood_type' => $this->blood_type,
            'units_available' => $this->units_available,
            'is_low_stock' => (bool) $this->is_low_stock,
            'is_critical' => (bool) $this->is_critical,
            'status' => $this->getStatusLabel(),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
    
    private function getStatusLabel()
    {
        if ($this->is_critical) {
            return 'critical';
        } elseif ($this->is_low_stock) {
            return 'low';
        } else {
            return 'normal';
        }
    }
}
