<?php
namespace App\Http\Resources\BloodBank;

use App\Http\Resources\UserShortResource;
use Illuminate\Http\Resources\Json\JsonResource;

class BloodDonationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'user' => new UserShortResource($this->whenLoaded('user')),
            'blood_bank_id' => $this->blood_bank_id,
            'blood_bank' => new BloodBankResource($this->whenLoaded('bloodBank')),
            'request_id' => $this->request_id,
            'request' => new BloodRequestResource($this->whenLoaded('request')),
            'blood_type' => $this->blood_type,
            'units' => $this->units,
            'donation_date' => $this->donation_date->format('Y-m-d'),
            'status' => $this->status,
            'notes' => $this->notes,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}