<?php

namespace App\Http\Requests\Messenger;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ReadReceiptRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'message_ids' => ['required', 'array', 'max:100'],
            'message_ids.*' => ['integer', 'exists:messages,id'],
            'type' => ['nullable', 'string', Rule::in(['delivered', 'seen'])],
        ];
    }

    public function messages(): array
    {
        return [
            'message_ids.required' => 'Message IDs are required.',
            'message_ids.max' => 'Maximum 100 messages can be marked at once.',
            'message_ids.*.exists' => 'One or more messages do not exist.',
        ];
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'type' => $this->type ?? 'seen',
        ]);
    }
}
