<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Setting;

class DeveloperMode
{
    public function handle(Request $request, Closure $next)
    {
        // Check DB setting for developer mode
        $developerMode = Setting::where('name', 'developer_mode')->first();
        
        if ($developerMode && ($developerMode->val == 1 || $developerMode->val === '1')) {
            // Enable error reporting
            error_reporting(E_ALL);
            ini_set('display_errors', 1);
            ini_set('display_startup_errors', 1);
            
            // Only allow admins to access the site in developer mode
            // if (!Auth::check() || Auth::user()->user_role !== 'admin') {
            //     return response()->json([
            //         'error' => 'Developer mode is enabled. Only administrators can access the site.'
            //     ], 403);
            // }
        } else {
            // Disable error reporting in production
            error_reporting(0);
            ini_set('display_errors', 0);
            ini_set('display_startup_errors', 0);
        }

        return $next($request);
    }
}
