<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Setting;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckModuleStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string  $module  The module to check (e.g., 'pages', 'groups')
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $module): Response
    {
        $moduleStatus = Setting::where('name', $module)->first();
        
        if (!$moduleStatus || $moduleStatus->val != '1') {
            abort(404);
        }

        return $next($request);
    }
}
