<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use App\Models\Setting;

class CacheSystem
{
    public function handle(Request $request, Closure $next)
    {
        // Check DB setting
        $cacheSystem = Setting::where('name', 'cache_system')->first();
        // dd($cacheSystem->val);
        // Disable cache if setting is 0 or doesn't exist
        if (!$cacheSystem || $cacheSystem->val == 0 || $cacheSystem->val === '0') {
            Cache::setDefaultDriver('null');
        }
        // dd(Cache::getDefaultDriver());

        return $next($request);
    }
}