<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Permission;

class RoleController extends Controller
{
    public function index()
    {
        $data['page_title'] = 'All Roles';
        $data['roles'] = Role::all();
        return view('admin.pages.roles.index',$data);
    }
    public function create()
    {
        $data['page_title'] = 'Create Role';
        return view('admin.pages.roles.create',$data);
    }
    public function store(Request $request)
    {
        $validate = $request->validate([
            'name'=>'required|unique:roles'
        ]);
        $name = $request->input('name');
        $name = str_replace(' ', '-',$name);
        $res = Role::create(['name'=>$name]);
        if($res)
        {
            session()->flash('message', 'Role Created Successfully');
            return back();
        }
    }
    public function edit($id)
    {
        $data['page_title'] = 'Edit Role';
        $data['role'] = Role::find($id);
        return view('admin.roles.edit',$data);
    }
    public function update($id,Request $request)
    {
        $validate = $request->validate([
            'name'=>['required',Rule::unique('roles', 'name')->ignore($id)]
        ]);
        $role = Role::find($id);
        if($role->status=='yes')
        {
            $name = $request->input('name');
            $name = str_replace(' ', '-',$name);
            $res = Role::where('id',$id)->update(['name'=>$name]);
            if($res)
            {
                session()->flash('message', 'Role Updated Successfully');
                return redirect()->route('admin.roles.index');
            }
        }
        else
        {
            session()->flash('error', 'Can not update the administrator role');
            return redirect()->route('admin.roles.index');
        }

    }
    public function delete($id)
    {
        $role = Role::find($id);
        if($role->status=='yes')
        {
            $res = Role::where('id',$id)->delete();
            if($res)
            {
                session()->flash('message', 'Role deleted Successfully');
                return redirect()->route('admin.roles.index');
            }
        }
        else
        {
            session()->flash('message', 'Role is not deleteable ');
            return redirect()->route('admin.roles.index');
        }
    }
    public function assignpermission($id)
    {
        $data['page_title'] = 'Assign Permission ';
        $data['role'] = Role::find($id);
        $data['permissions'] = Permission::all();
        return view('admin.pages.roles.assignpermission',$data);
    }
    public function allowpermissions(Request $request,$id)
    {
        $role = Role::find($id);
       
        $permissions = $request->input('permissions');
        if($role->status=='yes')
        {
            $role->syncPermissions($permissions);
            session()->flash('message', 'Permission synced Successfully');
            return  redirect()->route('admin.roles.index');
        }
        session()->flash('error', "Can not update the administrator's permissions");
        return  redirect()->route('admin.roles.index');
    }
}
