<?php 

use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;

if (!function_exists('uploadFile')) {
    /**
     * Upload a file to a specific folder and return its filename.
     *
     * @param UploadedFile $file The file to upload.
     * @param string $folder The folder where the file will be stored.
     * @return string|null
     */
    function uploadFile(UploadedFile $file, string $folder): ?string
    {
        $filename = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
        $path = $file->storeAs("public/$folder", $filename);

        return $path;
    }
}

if (!function_exists('getFileUrl')) {
    /**
     * Get the secure URL of a file in a specific folder.
     *
     * @param string $filename The filename.
     * @param string $folder The folder name.
     * @return string
     */
    function getFileUrl(string $filename, string $folder): string
    {
        $path = "storage/$folder/$filename";

        return Storage::exists("public/$folder/$filename") ? asset($path) : asset('images/no-image.png');
    }
}

