<?php

use Illuminate\Support\Facades\Route;
use Modules\WebsiteInfo\Http\Controllers\Backend\WebsiteInfosController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


/*
*
* Backend Routes
*
* --------------------------------------------------------------------
*/
Route::group(['namespace' => '\Modules\WebsiteInfo\Http\Controllers\Backend', 'as' => 'backend.', 'middleware' => ['web', 'auth', 'can:view_backend'], 'prefix' => 'admin'], function () {
   
    $module_name = 'websiteinfos';
    $controller_name = 'WebsiteInfosController';
    Route::get("site-setting", [WebsiteInfosController::class, 'index'])->name('site.info');
    Route::post("update-site-information", [WebsiteInfosController::class, 'updateSiteInfo'])->name('update.site.setting');
    Route::resource("$module_name", "$controller_name");
});
