<?php

use Illuminate\Support\Facades\Route;
use Modules\FileConfiguration\Http\Controllers\Backend\FileConfigurationsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


/*
*
* Backend Routes
*
* --------------------------------------------------------------------
*/
Route::group(['namespace' => '\Modules\FileConfiguration\Http\Controllers\Backend', 'as' => 'backend.', 'middleware' => ['web', 'auth', 'can:view_backend'], 'prefix' => 'admin'], function () {
    
    $module_name = 'fileconfigurations';
    $controller_name = 'FileConfigurationsController';
    Route::get("File-Upload-Configuration", [FileConfigurationsController::class, 'index'])->name('fileConfiguration');
    Route::resource("$module_name", "$controller_name");
});
