<?php

namespace Modules\FileConfiguration\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\FileConfiguration\Models\FileConfiguration;

class FileConfigurationDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key checks!
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        /*
         * FileConfigurations Seed
         * ------------------
         */

        // DB::table('fileconfigurations')->truncate();
        // echo "Truncate: fileconfigurations \n";

        FileConfiguration::factory()->count(20)->create();
        $rows = FileConfiguration::all();
        echo " Insert: fileconfigurations \n\n";

        // Enable foreign key checks!
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
