@extends("backend.layouts.app")

@section("title")
    Email & SMS Setup
@endsection

@section("breadcrumbs")
    <x-backend.breadcrumbs>
        <x-backend.breadcrumb-item icon="c-icon fas fa-gear">
            Settings
        </x-backend.breadcrumb-item>
        <x-backend.breadcrumb-item type="active" icon="c-icon fa-solid fa-envelope">
            Email & SMS Setup
        </x-backend.breadcrumb-item>
    </x-backend.breadcrumbs>
@endsection

@section("content")
<link rel="stylesheet" href="{{asset('css/custom.css')}}">

    <div class="row">
        <div class="col-md-12">
            <p class="alert alert-info p-3">
                <i class="fa fa-warning"></i> <b>Info:</b> For more information on how to setup e-mail server or SMS providers, please visit our <a href="https://docs.wowonder.com/#idocs_smtp" target="_blank">Documentation</a> page.
            </p>
        </div>
        <div class="col-12 col-md-6 col-lg-6 col-xl-6">
            <div class="card p-3 mb-3">
                <h5 class="card-title">
                    E-mail Configuration
                </h5>
                <div class="card-body">

                    <div class="form-group mb-3 border-b-2">
                        <label for="video_upload_sharing" class="mb-2 item-name">E-mail Server</label>
                        <select name="email_server" id="email_server" class="form-control">
                            <option value="">Choose Default Server</option>
                            <option value="smtp" @if(setting('email_server') == 'smtp') selected @endif>SMTP Server</option>
                            <option value="mail" @if(setting('email_server') == 'mail') selected @endif>Server Mail (Default)</option>
                        </select>
                        <p class="admin-info">Select which E-mail server you want to use, Server Mail function is not recommended.
                        </p>
                    </div>
                    <div class="form-group mb-3 border-b-2">
                        <label for="site_default_email" class="mb-2 item-name">Website Default E-mail</label>
                        <input class="form-control" type="text" id="site_default_email" value="{{setting('site_default_email')}}">
                        
                        <p class="admin-info">This is your default website E-mail, this will be used to send E-mails to users.
                        </p>
                    </div>
                    <div class="form-group mb-3 border-b-2">
                        <label for="smtp_host" class="mb-2 item-name">SMTP Host</label>
                        <input class="form-control" type="text" id="smtp_host" value="{{setting('smtp_host')}}">
                        <p class="admin-info">Your SMTP account host name, can be IP, domain or subdomain.
                        </p>
                    </div>
                    <div class="form-group mb-3 border-b-2">
                        <label for="smtp_username" class="mb-2 item-name">SMTP Username</label>
                        <input class="form-control" type="text" id="smtp_username" value="{{setting('smtp_username')}}">
                        <p class="admin-info">Your SMTP account username.
                        </p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="smtp_password" class="mb-2 item-name">SMTP Password</label>
                        <p class="alert alert-danger p-2 mb-2">
                            The secret key is not showing due security reasons, you can still overwrite the current one.
                        </p>
                        <input class="form-control" type="text" id="smtp_password" value="{{setting('smtp_password')}}">
                        <p class="admin-info">Your SMTP account password.
                        </p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="smtp_port" class="mb-2 item-name">SMTP Port</label>
                        <input class="form-control" type="text" id="smtp_port" value="{{setting('smtp_port')}}">
                        <p class="admin-info">Which port does your SMTP server use? most used 587 for TLS, and 465 for SSL encryption.
                        </p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="smtp_encryption" class="mb-2 item-name">SMTP Encryption</label>
                        <select name="smtp_encryption" id="smtp_encryption" class="form-control">
                            <option value="">Choose SMTP Encryption</option>
                            <option value="tls" @if(setting('smtp_encryption') == 'tls') selected @endif>TLS (Default, Not Secured)</option>
                            <option value="ssl" @if(setting('smtp_encryption') == 'ssl') selected @endif>SSL (Secure)</option>
                        </select>
                        <p class="admin-info">Which encryption method does your SMTP server use?
                        </p>
                    </div>

                    <p class="alert alert-info p-3 mt-3">
                        After clicking "Test E-mail Server", a test message will be sent to your account's email address.
                    </p>
                    <div class="from-group">
                        <button class="btn btn-primary" style="width: 40%">
                            Test Email Server
                        </button>
                    </div>
                </div>
            </div>

            <div class="card p-3 mb-3">
                <h5 class="card-title">
                    SMS Settings
                </h5>
                <div class="card-body">
                    <p class="alert alert-info p-3">
                        To start sending SMS, you have to create an account and buy credits in <a href="http://www.twilio.com/" target="_blank">Twilio</a> OR <a href="http://www.bulksms.com/" target="_blank">BulkSMS</a> OR <a href="https://www.infobip.com/" target="_blank">Infobip</a>.
                    </p>
                    <div class="form-group mb-3 border-b-2">
                        <label for="video_upload_sharing" class="mb-2 item-name">Default SMS Provider</label>
                        <select name="bulk_sms_provider" id="bulk_sms_provider" class="form-control">
                            <option value="">Choose Default SMS Provider</option>
                            <option value="bulk_sms" @if(setting('bulk_sms_provider') == 'bulk_sms') selected @endif>BulkSMS</option>
                            <option value="twilio" @if(setting('bulk_sms_provider') == 'twilio') selected @endif>Twilio</option>
                            <option value="infobip" @if(setting('bulk_sms_provider') == 'infobip') selected @endif>Infobip</option>
                        </select>
                        <p class="admin-info">Select which SMS provider you want to use, you can use only one at the same time.
                        </p>
                    </div>
                    <div class="form-group mb-3 border-b-2">
                        <label for="sms_phone_number" class="mb-2 item-name">Your Phone Number</label>
                        <input class="form-control" type="text" id="sms_phone_number" value="{{setting('sms_phone_number')}}">
                        
                        <p class="admin-info">Set your website default number, this will be used to send SMS to users, e.g (+9053..)
                        </p>
                    </div>
                    <label for="" class="mb-3 item-name">BulkSMS Configuration</label>
                    <div class="form-group mb-3 border-b-2">
                        <label for="bul_sms_username">BulkSMS Username</label>
                        <input class="form-control" type="text" id="bul_sms_username" value="{{setting('bul_sms_username')}}">
                    </div>
                    <div class="form-group mb-3 border-b-2">
                        <label for="bulk_sms_password">BulkSMS Password</label>
                        <input class="form-control" type="text" id="bulk_sms_password" value="{{setting('bulk_sms_password')}}">
                    </div>
                    <label for="" class="mb-3 item-name">Twilio Configuration</label>
                    <div class="form-group mb-3 border-b-2">
                        <label for="twilio_account_sid">Twilio account_sid</label>
                        <input class="form-control" type="text" id="twilio_account_sid" value="{{setting('twilio_account_sid')}}">
                        </p>
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="twilio_auth_token">Twilio auth_token</label>
                        <input class="form-control" type="text" id="twilio_auth_token" value="{{setting('twilio_auth_token')}}">
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="twilio_phone_number">Twilio Phone number</label>
                        <input class="form-control" type="text" id="twilio_phone_number" value="{{setting('twilio_phone_number')}}">
                    </div>
                    <label for="" class="mb-3 item-name">Infobip Configuration</label>
                    <div class="form-group mb-3 border-b-2">
                        <label for="infobip_api_key">Infobip API Key</label>
                        <input class="form-control" type="text" id="infobip_api_key" value="{{setting('infobip_api_key')}}">
                    </div>

                    <div class="form-group mb-3 border-b-2">
                        <label for="infobip_base_url">Infobip Base URL</label>
                        <input class="form-control" type="text" id="infobip_base_url" value="{{setting('infobip_base_url')}}">
                    </div>

                    <p class="alert alert-info p-3 mt-3">
                        After clicking "Test SMS Server", a test message will be sent to your phone
                    </p>
                    <div class="from-group">
                        <button class="btn btn-primary" style="width: 40%">
                            Test SMS Server
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-6 col-xl-6">
            <div class="card p-3 mb-3">
                <h5 class="card-title">
                    Debug Email Deliverability
                </h5>
                <div class="card-body">
                    <p class="alert alert-info p-3">This feature will test the Email Deliverability and make sure the system is working fine.</p>
                    <div class="form-group mb-3 border-b-2">
                        <label for="allowed_extensions">Debug Log</label>
                        <textarea name="email_debug_log" id="email_debug_log" class="form-control" rows="20" style="background: #f1f1f1" readonly>Click on Debug Email Deliverability to show test results.</textarea>
                    </div>

                    <div class="form-group">
                        <button class="btn btn-primary" style="width: 60%">Debug Email Deliverability</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin.backend.layouts.update_settings')
@endsection
